/*
 * Decompiled with CFR 0.152.
 */
package jade;

import jade.core.Agent;
import jade.core.MicroRuntime;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;
import jade.util.leap.Properties;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class MicroBoot
extends MIDlet
implements Runnable {
    private Logger logger;

    public void startApp() throws MIDletStateChangeException {
        boolean quit = false;
        if (Agent.midlet != null) {
            quit = true;
        }
        Agent.midlet = this;
        this.logger = Logger.getMyLogger(this.getClass().getName());
        if (quit) {
            if (this.logger.isLoggable(10)) {
                this.logger.log(10, "JADE runtime already active");
            }
            return;
        }
        try {
            String source = this.getAppProperty("LEAP-conf");
            if (source == null && (source = this.getAppProperty("MIDlet-LEAP-conf")) == null) {
                source = "jad";
            }
            Properties props = new Properties();
            props.load(source);
            if (props.getProperty("jvm") == null) {
                props.setProperty("jvm", "midp");
            }
            Logger.initialize(props);
            this.customize(props);
            if (null instanceof ACLMessage) {
                // empty if block
            }
            Runtime rt = Runtime.getRuntime();
            MicroRuntime.startJADE(props, this);
            rt.gc();
        }
        catch (Exception e) {
            if (this.logger.isLoggable(10)) {
                this.logger.log(10, "Error reading configuration properties");
            }
            e.printStackTrace();
            Agent.midlet = null;
            this.notifyDestroyed();
        }
    }

    public void pauseApp() {
        if (this.logger.isLoggable(8)) {
            this.logger.log(8, "pauseApp() called");
        }
    }

    public void destroyApp(boolean unconditional) {
        if (this.logger.isLoggable(8)) {
            this.logger.log(8, "destroyApp() called");
        }
        MicroRuntime.stopJADE();
    }

    public void run() {
        if (Agent.midlet != null) {
            if (this.logger.isLoggable(8)) {
                this.logger.log(8, "Destroying MIDlet now");
            }
            Agent.midlet.notifyDestroyed();
        }
        Agent.midlet = null;
    }

    protected void customize(Properties props) {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)new Form("JADE version 3.4"));
    }
}

